unit UATP;

interface

uses
  Menus, ToolsAPI, SysUtils, UATPPlugins, FileCtrl,
  Windows, Registry;

type
  TATP = class
  private
    ATPMenuItem: TMenuItem;
    ConfigMenuItem: TMenuItem;
    Plugins: TATPPlugins;
    procedure ConfigMenuItemClick(Sender: TObject);
    procedure LoadATPMenu;

    // Obtem e grava a pasta de plugins no registro do windows
    // Solicita ao usurio caso no a encontre
    function GetPluginPathFromRegistry(const ForceSelection: Boolean = false): String;
  public
    constructor Create;
    destructor Destroy; override;
  published

  end;

var
  ATP: TATP;

implementation

{ TATPMenu }

procedure TATP.ConfigMenuItemClick(Sender: TObject);
begin
  Plugins.Path := GetPluginPathFromRegistry(true);
  LoadATPMenu;
end;

constructor TATP.Create;
begin
  ATPMenuItem := TMenuItem.Create(nil);
  ATPMenuItem.Caption := 'ATP';

  // Instancia a lista de Plugins
  Plugins := TATPPlugins.Create;

  // Carrega Pasta de Plugins e inicializa a lista
  Plugins.Path := GetPluginPathFromRegistry(false);

  // Carrega Menus do ATP
  LoadATPMenu;

  // Adiciona item de Menu ao Delphi
  (BorlandIDEServices as INTAServices).MainMenu.Items.Add(ATPMenuItem);
end;

destructor TATP.Destroy;
begin
  ATPMenuItem.Free;
  if Assigned(Plugins) then
    FreeAndNil(Plugins);
  inherited;
end;

function TATP.GetPluginPathFromRegistry(const ForceSelection: Boolean = false): String;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
   Reg.RootKey := HKEY_CURRENT_USER;
   if Reg.OpenKey('\Software\ATP\', True) then begin
     Result := Reg.ReadString('PluginPath');
   end;
   if (Result = '') or ForceSelection then begin
    if SelectDirectory('Selecione Pasta de Plugins','',Result) then begin
      Reg.WriteString('PluginPath',Result);
    end;
   end;
  finally
   Reg.Free;
  end;
end;

procedure TATP.LoadATPMenu;
var
  i: integer;
  Menu: TMenuItem;
  Description: string;
  SShortCut: string;
begin
  ATPMenuItem.Clear;

  ConfigMenuItem := TMenuItem.Create(ATPMenuItem);
  ConfigMenuItem.Caption := '&Configurao...';
  ConfigMenuItem.OnClick := ConfigMenuItemClick;

  ATPMenuItem.Add(ConfigMenuItem);

  // Varre a lista de plugins e cria os menus
  for i := 0 to Plugins.Count - 1 do begin
    // Obtem descrio e Tecla de atalho da DLL do plugin
    Description := Plugins[i].GetDescription;
    SShortCut := Plugins[i].GetShortCut;

    if Description <> '' then begin
      Menu := TMenuItem.Create(ATPMenuItem);
      Menu.Caption := Description;

      // Aponta o OnClick para o mtodo do plugin que realiza o trabalho
      // principal da aplicao que  processar e substituir o texto selecionado
      // no editor do Delphi.
      Menu.OnClick := Plugins[i].Execute;

      // converte o string  de tecla de atalho retornado pela DLL em  um
      // ShortCut vlido para o item de menu.
      if SShortCut <> '' then
        Menu.ShortCut := TextToShortCut(SShortCut);

      ATPMenuItem.Add(Menu);
    end;
  end;
end;

initialization
  ATP := TATP.Create;

finalization
  if Assigned(ATP) then
    FreeAndNil(ATP);

end.

